/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eks.tpcds;

import com.databricks.spark.sql.perf.Benchmark;
import com.databricks.spark.sql.perf.Query;
import com.databricks.spark.sql.perf.Variation;
import com.databricks.spark.sql.perf.tpcds.TPCDS;
import com.databricks.spark.sql.perf.tpcds.TPCDSTables;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class BenchmarkSQL$ {
    public static BenchmarkSQL$ MODULE$;

    static {
        new BenchmarkSQL$();
    }

    public void main(String[] args) {
        Seq<Query> filtered_queries;
        Seq seq;
        Some some;
        String tpcdsDataDir = args[0];
        String resultLocation = args[1];
        String dsdgenDir = args[2];
        String format = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> args[3].toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "parquet");
        String scaleFactor = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> args[4].toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "1");
        int iterations = new StringOps(Predef$.MODULE$.augmentString(args[5])).toInt();
        boolean optimizeQueries = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(args[6])).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        String filterQueries = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> args[7].toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        boolean onlyWarn = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(args[8])).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        String databaseName = "tpcds_db";
        int timeout = 86400;
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("DATA DIR is ").append(tpcdsDataDir).toString());
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(23).append("TPCDS SQL Benchmark ").append(scaleFactor).append(" GB").toString()).getOrCreate();
        if (onlyWarn) {
            Predef$.MODULE$.println((Object)"Only WARN");
            LogManager.getLogger((String)"org").setLevel(Level.WARN);
        }
        TPCDSTables tables = new TPCDSTables(spark.sqlContext(), dsdgenDir, scaleFactor, false, false);
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> spark.sql(new StringBuilder(16).append("create database ").append(databaseName).toString()));
        tables.createExternalTables(tpcdsDataDir, format, databaseName, true, true, tables.createExternalTables$default$6());
        if (optimizeQueries) {
            tables.analyzeTables(databaseName, true, tables.analyzeTables$default$3());
            spark.conf().set("spark.sql.cbo.enabled", "true");
        }
        TPCDS tpcds = new TPCDS(spark.sqlContext());
        ObjectRef query_filter = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        if (!filterQueries.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("Running only queries: ").append(filterQueries).toString());
            query_filter.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filterQueries.split(","))).toSeq();
        }
        Seq<Query> seq2 = !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)query_filter.elem)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? tpcds.tpcds2_13Queries() : (Seq<Query>)tpcds.tpcds2_13Queries().filter((Function1 & Serializable & scala.Serializable)q -> BoxesRunTime.boxToBoolean((boolean)BenchmarkSQL$.$anonfun$main$12(query_filter, q)));
        Seq<Query> x$1 = filtered_queries = seq2;
        int x$2 = iterations;
        String x$3 = resultLocation;
        boolean x$4 = true;
        boolean x$5 = tpcds.runExperiment$default$2();
        Seq<Variation<?>> x$6 = tpcds.runExperiment$default$4();
        Map<String, String> x$7 = tpcds.runExperiment$default$5();
        long x$8 = tpcds.runExperiment$default$6();
        Benchmark.ExperimentStatus experiment = tpcds.runExperiment(x$1, x$5, x$2, x$6, x$7, x$8, x$3, x$4);
        experiment.waitForFinish(timeout);
        String resultPath = experiment.resultPath();
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Reading result at ").append(resultPath).toString());
        Dataset specificResultTable = spark.read().json(resultPath);
        specificResultTable.show();
        Dataset result = specificResultTable.withColumn("result", functions$.MODULE$.explode(functions$.MODULE$.col("results"))).withColumn("executionSeconds", functions$.MODULE$.col("result.executionTime").$div((Object)BoxesRunTime.boxToInteger((int)1000))).withColumn("queryName", functions$.MODULE$.col("result.name"));
        result.select("iteration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"queryName", "executionSeconds"})).show();
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Final results at ").append(resultPath).toString());
        Dataset aggResults = result.groupBy("queryName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.callUDF("percentile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("executionSeconds").cast("double"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.5))})).as((Symbol)SymbolLiteral.bootstrap("apply", "medianRuntimeSeconds")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.callUDF("min", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("executionSeconds").cast("double")})).as((Symbol)SymbolLiteral.bootstrap("apply", "minRuntimeSeconds")), functions$.MODULE$.callUDF("max", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("executionSeconds").cast("double")})).as((Symbol)SymbolLiteral.bootstrap("apply", "maxRuntimeSeconds"))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("queryName")}));
        aggResults.repartition(1).write().csv(new StringBuilder(12).append(resultPath).append("/summary.csv").toString());
        aggResults.show(10);
        spark.stop();
    }

    public static final /* synthetic */ boolean $anonfun$main$12(ObjectRef query_filter$1, Query q) {
        return ((Seq)query_filter$1.elem).contains((Object)q.name());
    }

    private BenchmarkSQL$() {
        MODULE$ = this;
    }
}

