/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf;

import com.databricks.spark.sql.perf.Benchmark;
import com.databricks.spark.sql.perf.Benchmarkable;
import com.databricks.spark.sql.perf.RunBenchmark$;
import com.databricks.spark.sql.perf.RunConfig;
import com.databricks.spark.sql.perf.RunConfig$;
import com.databricks.spark.sql.perf.Variation;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class RunBenchmark$ {
    public static RunBenchmark$ MODULE$;

    static {
        new RunBenchmark$();
    }

    public void main(String[] args) {
        OptionParser<RunConfig> parser = new OptionParser<RunConfig>(){

            public static final /* synthetic */ RunConfig $anonfun$new$4(int x, RunConfig c) {
                int x$11 = x;
                String x$12 = c.copy$default$1();
                String x$13 = c.copy$default$2();
                Option<String> x$14 = c.copy$default$3();
                Option<Object> x$15 = c.copy$default$5();
                return c.copy(x$12, x$13, x$14, x$11, x$15);
            }

            public static final /* synthetic */ RunConfig $anonfun$new$5(long x, RunConfig c) {
                Some x$16 = new Some((Object)BoxesRunTime.boxToLong((long)x));
                String x$17 = c.copy$default$1();
                String x$18 = c.copy$default$2();
                Option<String> x$19 = c.copy$default$3();
                int x$20 = c.copy$default$4();
                return c.copy(x$17, x$18, x$19, x$20, (Option<Object>)x$16);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-sql-perf", "0.2.0"}));
                this.opt('m', "master", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5())).text("the Spark master to use, default to local[*]");
                this.opt('b', "benchmark", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    Option<String> x$3 = c.copy$default$3();
                    int x$4 = c.copy$default$4();
                    Option<Object> x$5 = c.copy$default$5();
                    return c.copy(x$2, x$1, x$3, x$4, x$5);
                }).text("the name of the benchmark to run").required();
                this.opt('f', "filter", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Some x$6 = new Some(x);
                    String x$7 = c.copy$default$1();
                    String x$8 = c.copy$default$2();
                    int x$9 = c.copy$default$4();
                    Option<Object> x$10 = c.copy$default$5();
                    return c.copy(x$7, x$8, (Option<String>)x$6, x$9, x$10);
                }).text("a filter on the name of the queries to run");
                this.opt('i', "iterations", Read$.MODULE$.intRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x), c)).text("the number of iterations to run");
                this.opt('c', "compare", Read$.MODULE$.longRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToLong((Object)x), c)).text("the timestamp of the baseline experiment to compare with");
                this.help("help").text("prints this usage text");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String com.databricks.spark.sql.perf.RunConfig ), $anonfun$new$2(java.lang.String com.databricks.spark.sql.perf.RunConfig ), $anonfun$new$3(java.lang.String com.databricks.spark.sql.perf.RunConfig ), $anonfun$new$4$adapted(java.lang.Object com.databricks.spark.sql.perf.RunConfig ), $anonfun$new$5$adapted(java.lang.Object com.databricks.spark.sql.perf.RunConfig )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new RunConfig(RunConfig$.MODULE$.apply$default$1(), RunConfig$.MODULE$.apply$default$2(), RunConfig$.MODULE$.apply$default$3(), RunConfig$.MODULE$.apply$default$4(), RunConfig$.MODULE$.apply$default$5()));
        if (option instanceof Some) {
            Some some = (Some)option;
            RunConfig config = (RunConfig)some.value();
            this.run(config);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void run(RunConfig config) {
        SparkConf conf = new SparkConf().setMaster(config.master()).setAppName(this.getClass().getName());
        SparkSession sparkSession = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        SparkContext sc = sparkSession.sparkContext();
        SQLContext sqlContext = sparkSession.sqlContext();
        sqlContext.setConf("spark.sql.perf.results", new File("performance").toURI().toString());
        Benchmark benchmark = (Benchmark)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Benchmark)Class.forName(config.benchmarkName()).newInstance()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Benchmark)Class.forName(new StringBuilder(30).append("com.databricks.spark.sql.perf.").append(config.benchmarkName()).toString()).newInstance());
        Seq allQueries = (Seq)config.filter().map((Function1 & Serializable & scala.Serializable)f -> (Seq)benchmark.allQueries().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RunBenchmark$.$anonfun$run$4(f, x$1)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> benchmark.allQueries());
        Predef$.MODULE$.println((Object)"== QUERY LIST ==");
        allQueries.foreach((Function1 & Serializable & scala.Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        Seq x$1 = allQueries;
        int x$2 = config.iterations();
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"runtype"), (Object)"local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"host"), (Object)InetAddress.getLocalHost().getHostName())}));
        boolean x$4 = benchmark.runExperiment$default$2();
        Seq<Variation<?>> x$5 = benchmark.runExperiment$default$4();
        long x$6 = benchmark.runExperiment$default$6();
        String x$7 = benchmark.runExperiment$default$7();
        boolean x$8 = benchmark.runExperiment$default$8();
        Benchmark.ExperimentStatus experiment = benchmark.runExperiment((Seq<Benchmarkable>)x$1, x$4, x$2, x$5, (Map<String, String>)x$3, x$6, x$7, x$8);
        Predef$.MODULE$.println((Object)"== STARTING EXPERIMENT ==");
        experiment.waitForFinish(1800000);
        sqlContext.setConf("spark.sql.shuffle.partitions", "1");
        Dataset toShow = experiment.getCurrentRuns().withColumn("result", functions$.MODULE$.explode((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"results"}))).$((Seq)Nil$.MODULE$))).select("result.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).groupBy("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.min((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "minTimeMs")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "maxTimeMs")), functions$.MODULE$.avg((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "avgTimeMs")), functions$.MODULE$.stddev((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).as((Symbol)SymbolLiteral.bootstrap("apply", "stdDev")), functions$.MODULE$.stddev((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).$div((Object)functions$.MODULE$.avg((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$))).$times((Object)BoxesRunTime.boxToInteger((int)100)).as((Symbol)SymbolLiteral.bootstrap("apply", "stdDevPercent"))})).orderBy("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Predef$.MODULE$.println((Object)"Showing at most 100 query results now");
        toShow.show(100);
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Results: sqlContext.read.json(\"").append(experiment.resultPath()).append("\")").toString());
        config.baseline().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)baseTimestamp -> {
            Column baselineTime = functions$.MODULE$.when(sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)baseTimestamp)), (Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).otherwise(null);
            Column thisRunTime = functions$.MODULE$.when(sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)experiment.timestamp())), (Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionTime"}))).$((Seq)Nil$.MODULE$)).otherwise(null);
            Dataset data = sqlContext.read().json(benchmark.resultsLocation()).coalesce(1).where(new StringBuilder(17).append("timestamp IN (").append(baseTimestamp).append(", ").append(experiment.timestamp()).append(")").toString()).withColumn("result", functions$.MODULE$.explode((Column)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"results"}))).$((Seq)Nil$.MODULE$))).select("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result.*"})).groupBy("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.avg(baselineTime).as((Symbol)SymbolLiteral.bootstrap("apply", "baselineTimeMs")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg(thisRunTime).as((Symbol)SymbolLiteral.bootstrap("apply", "thisRunTimeMs")), functions$.MODULE$.stddev(baselineTime).as((Symbol)SymbolLiteral.bootstrap("apply", "stddev"))})).withColumn("percentChange", sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baselineTimeMs"}))).$((Seq)Nil$.MODULE$).$minus((Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"thisRunTimeMs"}))).$((Seq)Nil$.MODULE$)).$div((Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baselineTimeMs"}))).$((Seq)Nil$.MODULE$)).$times((Object)BoxesRunTime.boxToInteger((int)100))).filter(sqlContext.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "thisRunTimeMs")).isNotNull());
            data.show(false);
        });
    }

    public static final /* synthetic */ boolean $anonfun$run$4(String f$1, Benchmarkable x$1) {
        return x$1.name().contains(f$1);
    }

    private RunBenchmark$() {
        MODULE$ = this;
    }
}

