/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf.mllib;

import com.databricks.spark.sql.perf.Benchmark;
import com.databricks.spark.sql.perf.RunConfig;
import com.databricks.spark.sql.perf.Variation;
import com.databricks.spark.sql.perf.mllib.MLBenchmarks$;
import com.databricks.spark.sql.perf.mllib.MLLib;
import com.databricks.spark.sql.perf.mllib.MLPipelineStageBenchmarkable;
import com.databricks.spark.sql.perf.mllib.MLTest;
import com.databricks.spark.sql.perf.mllib.YamlConfig;
import com.databricks.spark.sql.perf.mllib.YamlConfig$;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.io.Source$;

public final class MLLib$
implements scala.Serializable {
    public static MLLib$ MODULE$;
    private Logger logger;
    private final String smallConfig;
    private final String largeConfig;
    private volatile boolean bitmap$0;

    static {
        new MLLib$();
    }

    private Logger logger$lzycompute() {
        MLLib$ mLLib$ = this;
        synchronized (mLLib$) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger(this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Dataset<Row> runDefault(RunConfig runConfig) {
        MLLib ml = new MLLib();
        Seq<MLPipelineStageBenchmarkable> benchmarks = MLBenchmarks$.MODULE$.benchmarkObjects();
        Benchmark.ExperimentStatus e = ml.runExperiment(benchmarks, ml.runExperiment$default$2(), ml.runExperiment$default$3(), ml.runExperiment$default$4(), ml.runExperiment$default$5(), ml.runExperiment$default$6(), ml.runExperiment$default$7(), ml.runExperiment$default$8());
        e.waitForFinish(1800000);
        this.logger().info("Run finished");
        return e.getCurrentResults();
    }

    private String getConfig(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream(resourcePath);
        return Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String smallConfig() {
        return this.smallConfig;
    }

    public String largeConfig() {
        return this.largeConfig;
    }

    public void main(String[] args) {
        String configFile = args[0];
        this.run(configFile, this.run$default$2());
    }

    public YamlConfig getConf(String yamlFile, String yamlConfig) {
        return (YamlConfig)Option$.MODULE$.apply((Object)yamlFile).map((Function1 & Serializable & scala.Serializable)filename -> YamlConfig$.MODULE$.readFile((String)filename)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(yamlConfig != null);
            return YamlConfig$.MODULE$.readString(yamlConfig);
        });
    }

    public String getConf$default$1() {
        return null;
    }

    public String getConf$default$2() {
        return null;
    }

    public Seq<MLPipelineStageBenchmarkable> getBenchmarks(YamlConfig conf) {
        SQLContext sqlContext = MLBenchmarks$.MODULE$.sqlContext();
        Seq<MLTest> benchmarksDescriptions = conf.runnableBenchmarks();
        return (Seq)benchmarksDescriptions.map((Function1 & Serializable & scala.Serializable)mlb -> new MLPipelineStageBenchmarkable(mlb.params(), mlb.benchmark(), sqlContext), Seq$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> run(String yamlFile, String yamlConfig) {
        this.logger().info("Starting run");
        YamlConfig conf = this.getConf(yamlFile, yamlConfig);
        SparkConf sparkConf = new SparkConf().setAppName("MLlib QA").setMaster("local[2]");
        SparkContext sc = SparkContext$.MODULE$.getOrCreate(sparkConf);
        sc.setLogLevel("INFO");
        MLLib b = new MLLib();
        Seq<MLPipelineStageBenchmarkable> benchmarks = this.getBenchmarks(conf);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append(benchmarks.size()).append(" benchmarks identified:").toString());
        String str = ((TraversableOnce)benchmarks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.prettyPrint(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        Predef$.MODULE$.println((Object)str);
        this.logger().info("Starting experiments");
        Seq<MLPipelineStageBenchmarkable> x$12 = benchmarks;
        int x$2 = 1;
        String x$3 = conf.output();
        boolean x$4 = false;
        boolean x$5 = b.runExperiment$default$2();
        Seq<Variation<?>> x$6 = b.runExperiment$default$4();
        Map<String, String> x$7 = b.runExperiment$default$5();
        long x$8 = b.runExperiment$default$6();
        Benchmark.ExperimentStatus e = b.runExperiment(x$12, x$5, x$2, x$6, x$7, x$8, x$3, x$4);
        e.waitForFinish((int)conf.timeout().toSeconds());
        this.logger().info("Run finished");
        return e.getCurrentResults();
    }

    public String run$default$1() {
        return null;
    }

    public String run$default$2() {
        return null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MLLib$() {
        MODULE$ = this;
        this.smallConfig = this.getConfig("config/mllib-small.yaml");
        this.largeConfig = this.getConfig("config/mllib-large.yaml");
    }
}

