/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf.mllib;

import com.databricks.spark.sql.perf.BenchmarkResult;
import com.databricks.spark.sql.perf.BenchmarkResult$;
import com.databricks.spark.sql.perf.Benchmarkable;
import com.databricks.spark.sql.perf.BreakdownResult;
import com.databricks.spark.sql.perf.ExecutionMode;
import com.databricks.spark.sql.perf.ExecutionMode$SparkPerfResults$;
import com.databricks.spark.sql.perf.Failure;
import com.databricks.spark.sql.perf.MLMetric;
import com.databricks.spark.sql.perf.MLParams;
import com.databricks.spark.sql.perf.mllib.BenchmarkAlgorithm;
import com.databricks.spark.sql.perf.mllib.MLBenchContext;
import com.databricks.spark.sql.perf.mllib.MLPipelineStageBenchmarkable$;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u000f\u001f\u0001-B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003%1\tC\u0003N\u0001\u0011\u0005a\nC\u0004T\u0001\u0001\u0007I\u0011\u0002+\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"1a\u000e\u0001Q!\nUCqa\u001c\u0001A\u0002\u0013%A\u000bC\u0004q\u0001\u0001\u0007I\u0011B9\t\rM\u0004\u0001\u0015)\u0003V\u0011\u001d!\b\u00011A\u0005\nUDq\u0001 \u0001A\u0002\u0013%Q\u0010\u0003\u0004\u0000\u0001\u0001\u0006KA\u001e\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b\u0001!\u0019!C!\u0003\u001fA\u0001\"!\t\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003G\u0001!\u0019!C)\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\t\u0003_\u0001A\u0011\u000b\u0010\u00022!9\u00111\u0007\u0001\u0005R\u0005U\u0002bBA0\u0001\u0011\u0005\u0011qB\u0004\b\u0003Cr\u0002\u0012AA2\r\u0019ib\u0004#\u0001\u0002f!1Q\n\u0007C\u0001\u0003OBq!!\u001b\u0019\t\u0013\tY\u0007C\u0004\u0002\u0002b!I!a!\t\u0013\u0005m\u0005$!A\u0005\n\u0005u%\u0001H'M!&\u0004X\r\\5oKN#\u0018mZ3CK:\u001c\u0007.\\1sW\u0006\u0014G.\u001a\u0006\u0003?\u0001\nQ!\u001c7mS\nT!!\t\u0012\u0002\tA,'O\u001a\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u0005QA-\u0019;bEJL7m[:\u000b\u0003%\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u00173mA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001b\u000e\u0003\u0001J!!\u000e\u0011\u0003\u001b\t+gn\u00195nCJ\\\u0017M\u00197f!\tis'\u0003\u00029]\ta1+\u001a:jC2L'0\u00192mK\u00061\u0001/\u0019:b[N\u0004\"aM\u001e\n\u0005q\u0002#\u0001C'M!\u0006\u0014\u0018-\\:\u0002\tQ,7\u000f\u001e\t\u0003\u007f\u0001k\u0011AH\u0005\u0003\u0003z\u0011!CQ3oG\"l\u0017M]6BY\u001e|'/\u001b;i[\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0005\u0011[U\"A#\u000b\u0005\r2%BA\u0013H\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051+%AC*R\u0019\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"Ba\u0014)R%B\u0011q\b\u0001\u0005\u0006s\u0011\u0001\rA\u000f\u0005\u0006{\u0011\u0001\rA\u0010\u0005\u0006\u0005\u0012\u0001\raQ\u0001\ti\u0016\u001cH\u000fR1uCV\tQ\u000b\u0005\u0002WI:\u0011qK\u0019\b\u00031\u0006t!!\u00171\u000f\u0005i{fBA._\u001b\u0005a&BA/+\u0003\u0019a$o\\8u}%\t!*\u0003\u0002I\u0013&\u0011QeR\u0005\u0003G\u0019K!aY#\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!aY#\u0002\u0019Q,7\u000f\u001e#bi\u0006|F%Z9\u0015\u0005%d\u0007CA\u0017k\u0013\tYgF\u0001\u0003V]&$\bbB7\u0007\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014!\u0003;fgR$\u0015\r^1!\u00031!(/Y5oS:<G)\u0019;b\u0003A!(/Y5oS:<G)\u0019;b?\u0012*\u0017\u000f\u0006\u0002je\"9Q.CA\u0001\u0002\u0004)\u0016!\u0004;sC&t\u0017N\\4ECR\f\u0007%A\u0007uKN$H)\u0019;b\u0007>,h\u000e^\u000b\u0002mB\u0019Qf^=\n\u0005at#AB(qi&|g\u000e\u0005\u0002.u&\u00111P\f\u0002\u0005\u0019>tw-A\tuKN$H)\u0019;b\u0007>,h\u000e^0%KF$\"!\u001b@\t\u000f5d\u0011\u0011!a\u0001m\u0006qA/Z:u\t\u0006$\u0018mQ8v]R\u0004\u0013!\u00029be\u0006lWCAA\u0003!\ry\u0014qA\u0005\u0004\u0003\u0013q\"AD'M\u0005\u0016t7\r[\"p]R,\u0007\u0010^\u0001\u0007a\u0006\u0014\u0018-\u001c\u0011\u0002\t9\fW.Z\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001c9!\u0011QCA\f!\tYf&C\u0002\u0002\u001a9\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\r]\u0005)a.Y7fA\u0005iQ\r_3dkRLwN\\'pI\u0016,\"!a\n\u0011\u0007M\nI#C\u0002\u0002,\u0001\u0012Q\"\u0012=fGV$\u0018n\u001c8N_\u0012,\u0017AD3yK\u000e,H/[8o\u001b>$W\rI\u0001\u0010E\u00164wN]3CK:\u001c\u0007.\\1sWR\t\u0011.A\u0006e_\n+gn\u00195nCJ\\G\u0003CA\u001c\u0003{\t9%a\u0013\u0011\u0007M\nI$C\u0002\u0002<\u0001\u0012qBQ3oG\"l\u0017M]6SKN,H\u000e\u001e\u0005\b\u0003\u007f)\u0002\u0019AA!\u0003AIgn\u00197vI\u0016\u0014%/Z1lI><h\u000eE\u0002.\u0003\u0007J1!!\u0012/\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0013\u0016!\u0003\u0005\r!!\u0005\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\b\u0003\u001b*\u0002\u0019AA(\u0003!iWm]:bO\u0016\u001c\bCBA)\u00037\n\t\"\u0004\u0002\u0002T)!\u0011QKA,\u0003\u001diW\u000f^1cY\u0016T1!!\u0017/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\n\u0019FA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018a\u00039sKR$\u0018\u0010\u0015:j]R\fA$\u0014'QSB,G.\u001b8f'R\fw-\u001a\"f]\u000eDW.\u0019:lC\ndW\r\u0005\u0002@1M\u0019\u0001\u0004\f\u001c\u0015\u0005\u0005\r\u0014A\u00029qe&tG\u000f\u0006\u0003\u0002n\u0005u\u0004CBA8\u0003o\n\tB\u0004\u0003\u0002r\u0005UdbA.\u0002t%\tq&\u0003\u0002d]%!\u0011\u0011PA>\u0005\r\u0019V-\u001d\u0006\u0003G:Ba!a \u001b\u0001\u0004a\u0013!\u00019\u0002\u0017\u001d,GoQ\"QCJ\fWn\u001d\u000b\u0005\u0003\u000b\u000b9\n\u0005\u0005\u0002\b\u00065\u0015\u0011CAI\u001b\t\tII\u0003\u0003\u0002\f\u0006]\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\ty)!#\u0003\u00075\u000b\u0007\u000fE\u0002.\u0003'K1!!&/\u0005\r\te.\u001f\u0005\u0007\u00033[\u0002\u0019\u0001\u0017\u0002\u0005\r\u001c\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006!A.\u00198h\u0015\t\tI+\u0001\u0003kCZ\f\u0017\u0002BAW\u0003G\u0013aa\u00142kK\u000e$\b")
public class MLPipelineStageBenchmarkable
implements Benchmarkable,
scala.Serializable {
    private final MLParams params;
    private final BenchmarkAlgorithm test;
    private Dataset<Row> testData;
    private Dataset<Row> trainingData;
    private Option<Object> testDataCount;
    private final MLBenchContext param;
    private final String name;
    private final ExecutionMode executionMode;
    private final transient SparkSession sqlSession;
    private final transient SQLContext sqlContext;
    private final transient SparkContext sparkContext;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public final BenchmarkResult benchmark(boolean includeBreakdown, String description, ArrayBuffer<String> messages, long timeout, boolean forkThread) {
        return Benchmarkable.benchmark$(this, includeBreakdown, description, messages, timeout, forkThread);
    }

    @Override
    public final String benchmark$default$2() {
        return Benchmarkable.benchmark$default$2$(this);
    }

    @Override
    public final boolean benchmark$default$5() {
        return Benchmarkable.benchmark$default$5$(this);
    }

    @Override
    public void afterBenchmark(SparkContext sc) {
        Benchmarkable.afterBenchmark$(this, sc);
    }

    @Override
    public String doBenchmark$default$2() {
        return Benchmarkable.doBenchmark$default$2$(this);
    }

    @Override
    public <A> double measureTimeMs(Function0<A> f) {
        return Benchmarkable.measureTimeMs$(this, f);
    }

    @Override
    public <A> Tuple2<Duration, A> measureTime(Function0<A> f) {
        return Benchmarkable.measureTime$(this, f);
    }

    @Override
    public SparkSession sqlSession() {
        return this.sqlSession;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    private Logger logger$lzycompute() {
        MLPipelineStageBenchmarkable mLPipelineStageBenchmarkable = this;
        synchronized (mLPipelineStageBenchmarkable) {
            if (!this.bitmap$0) {
                this.logger = Benchmarkable.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void com$databricks$spark$sql$perf$Benchmarkable$_setter_$sqlSession_$eq(SparkSession x$1) {
        this.sqlSession = x$1;
    }

    @Override
    public void com$databricks$spark$sql$perf$Benchmarkable$_setter_$sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void com$databricks$spark$sql$perf$Benchmarkable$_setter_$sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    private Dataset<Row> testData() {
        return this.testData;
    }

    private void testData_$eq(Dataset<Row> x$1) {
        this.testData = x$1;
    }

    private Dataset<Row> trainingData() {
        return this.trainingData;
    }

    private void trainingData_$eq(Dataset<Row> x$1) {
        this.trainingData = x$1;
    }

    private Option<Object> testDataCount() {
        return this.testDataCount;
    }

    private void testDataCount_$eq(Option<Object> x$1) {
        this.testDataCount = x$1;
    }

    private MLBenchContext param() {
        return this.param;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ExecutionMode executionMode() {
        return this.executionMode;
    }

    @Override
    public void beforeBenchmark() {
        this.logger().info(new StringBuilder(16).append(this).append(" beforeBenchmark").toString());
        try {
            this.testData_$eq(this.test.testDataSet(this.param()));
            this.testData().cache();
            this.testDataCount_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.testData().count())));
            this.trainingData_$eq(this.test.trainingDataSet(this.param()));
            this.trainingData().cache();
            this.trainingData().count();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Predef$.MODULE$.println((Object)new StringBuilder(27).append(this).append(" error in beforeBenchmark: ").append(Predef.RichException$.MODULE$.getStackTraceString$extension(Predef$.MODULE$.RichException(e))).toString());
                throw e;
            }
            throw throwable;
        }
    }

    @Override
    public BenchmarkResult doBenchmark(boolean includeBreakdown, String description, ArrayBuffer<String> messages) {
        BenchmarkResult benchmarkResult;
        try {
            try {
                Transformer model;
                Duration trainingTime;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        tuple2 = this.measureTime((Function0 & Serializable & scala.Serializable)() -> {
                            Model model;
                            this.logger().info(new StringBuilder(21).append(this).append(": train: trainingSet=").append(this.trainingData().schema()).toString());
                            PipelineStage pipelineStage = $this.test.getPipelineStage(this.param());
                            if (pipelineStage instanceof Estimator) {
                                Estimator estimator = (Estimator)pipelineStage;
                                model = estimator.fit(this.trainingData());
                            } else if (pipelineStage instanceof Transformer) {
                                Transformer transformer = (Transformer)pipelineStage;
                                transformer.transform(this.trainingData());
                                model = transformer;
                            } else {
                                if (pipelineStage != null) {
                                    PipelineStage pipelineStage2 = pipelineStage;
                                    throw new UnsupportedOperationException(new StringBuilder(75).append("Algorithm to benchmark must").append(" be an estimator or transformer, found ").append(pipelineStage2.getClass()).append(" instead.").toString());
                                }
                                throw new MatchError((Object)pipelineStage);
                            }
                            return model;
                        });
                        if (tuple2 == null) break block11;
                        trainingTime = (Duration)tuple2._1();
                        model = (Transformer)tuple2._2();
                        if (model != null) break block12;
                    }
                    throw new MatchError(tuple2);
                }
                Transformer transformer = model;
                Tuple2 tuple2 = new Tuple2((Object)trainingTime, (Object)transformer);
                Tuple2 tuple22 = tuple2;
                Duration trainingTime2 = (Duration)tuple22._1();
                Transformer model2 = (Transformer)tuple22._2();
                this.logger().info(new StringBuilder(7).append("model: ").append(model2).toString());
                Tuple2 tuple23 = this.measureTime((Function0 & Serializable & scala.Serializable)() -> $this.test.score(this.param(), this.trainingData(), model2));
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                Duration scoreTrainTime = (Duration)tuple23._1();
                MLMetric scoreTraining = (MLMetric)tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)scoreTrainTime, (Object)scoreTraining);
                Tuple2 tuple25 = tuple24;
                Duration scoreTrainTime2 = (Duration)tuple25._1();
                MLMetric scoreTraining2 = (MLMetric)tuple25._2();
                MLMetric metricTrainingTime = new MLMetric("training.time", trainingTime2.toMillis(), false);
                MLMetric metricTraining = new MLMetric(new StringBuilder(9).append("training.").append(scoreTraining2.metricName()).toString(), scoreTraining2.metricValue(), scoreTraining2.isLargerBetter());
                Tuple2 tuple26 = this.measureTime((Function0 & Serializable & scala.Serializable)() -> $this.test.score(this.param(), this.testData(), model2));
                if (tuple26 == null) {
                    throw new MatchError(tuple26);
                }
                Duration scoreTestTime = (Duration)tuple26._1();
                MLMetric scoreTest = (MLMetric)tuple26._2();
                Tuple2 tuple27 = new Tuple2((Object)scoreTestTime, (Object)scoreTest);
                Tuple2 tuple28 = tuple27;
                Duration scoreTestTime2 = (Duration)tuple28._1();
                MLMetric scoreTest2 = (MLMetric)tuple28._2();
                MLMetric metricTestTime = new MLMetric("test.time", scoreTestTime2.toMillis(), false);
                MLMetric metricTest = new MLMetric(new StringBuilder(5).append("test.").append(scoreTraining2.metricName()).toString(), scoreTraining2.metricValue(), scoreTraining2.isLargerBetter());
                this.logger().info(new StringBuilder(84).append(this).append(" doBenchmark: Trained model in ").append((double)trainingTime2.toMillis() / 1000.0).append(" s, Scored training dataset in ").append((double)scoreTrainTime2.toMillis() / 1000.0).append(" s,").append(" test dataset in ").append((double)scoreTestTime2.toMillis() / 1000.0).append(" s").toString());
                MLMetric[] additionalTests = (MLMetric[])((TraversableOnce)this.test.testAdditionalMethods(this.param(), model2).map((Function1 & Serializable & scala.Serializable)tuple -> {
                    Duration additionalMethodTime;
                    Tuple2 tuple2 = this.measureTime((Function0)tuple._2());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Duration duration = additionalMethodTime = (Duration)tuple2._1();
                    Duration additionalMethodTime2 = duration;
                    return new MLMetric((String)tuple._1(), additionalMethodTime2.toMillis(), false);
                }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MLMetric.class));
                MLMetric[] mlMetrics = (MLMetric[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new MLMetric[]{metricTrainingTime, metricTraining, metricTestTime, metricTest})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])additionalTests)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MLMetric.class)));
                Map<String, String> paramsMap = this.params.toMap();
                String benchmarkId = new StringBuilder(1).append((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.name())).split('.'))).last()).append("_").append(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(paramsMap.hashCode()))).toString();
                String x$1 = this.name();
                String x$2 = this.executionMode().toString();
                Map<String, String> x$3 = paramsMap;
                Some x$42 = new Some((Object)BoxesRunTime.boxToDouble((double)trainingTime2.toMillis()));
                Some x$52 = new Some((Object)mlMetrics);
                Some x$6 = new Some((Object)benchmarkId);
                Seq<String> x$7 = BenchmarkResult$.MODULE$.apply$default$4();
                Seq<String> x$8 = BenchmarkResult$.MODULE$.apply$default$5();
                Option<Object> x$9 = BenchmarkResult$.MODULE$.apply$default$6();
                Option<Object> x$10 = BenchmarkResult$.MODULE$.apply$default$7();
                Option<Object> x$11 = BenchmarkResult$.MODULE$.apply$default$8();
                Option<Object> x$12 = BenchmarkResult$.MODULE$.apply$default$9();
                Option<Object> x$13 = BenchmarkResult$.MODULE$.apply$default$11();
                Seq<BreakdownResult> x$14 = BenchmarkResult$.MODULE$.apply$default$12();
                Option<String> x$15 = BenchmarkResult$.MODULE$.apply$default$13();
                Option<Failure> x$16 = BenchmarkResult$.MODULE$.apply$default$14();
                benchmarkResult = new BenchmarkResult(x$1, x$2, x$3, x$7, x$8, x$9, x$10, x$11, x$12, (Option<Object>)x$42, x$13, x$14, x$15, x$16, (Option<MLMetric[]>)x$52, (Option<String>)x$6);
            }
            catch (Exception e) {
                String x$17 = this.name();
                String x$18 = this.executionMode().toString();
                Map<String, String> x$19 = this.params.toMap();
                Some x$20 = new Some((Object)new Failure(e.getClass().getSimpleName(), new StringBuilder(2).append(e.getMessage()).append(":\n").append(Predef.RichException$.MODULE$.getStackTraceString$extension(Predef$.MODULE$.RichException((Throwable)e))).toString()));
                Seq<String> x$21 = BenchmarkResult$.MODULE$.apply$default$4();
                Seq<String> x$22 = BenchmarkResult$.MODULE$.apply$default$5();
                Option<Object> x$23 = BenchmarkResult$.MODULE$.apply$default$6();
                Option<Object> x$24 = BenchmarkResult$.MODULE$.apply$default$7();
                Option<Object> x$25 = BenchmarkResult$.MODULE$.apply$default$8();
                Option<Object> x$26 = BenchmarkResult$.MODULE$.apply$default$9();
                Option<Object> x$27 = BenchmarkResult$.MODULE$.apply$default$10();
                Option<Object> x$28 = BenchmarkResult$.MODULE$.apply$default$11();
                Seq<BreakdownResult> x$29 = BenchmarkResult$.MODULE$.apply$default$12();
                Option<String> x$30 = BenchmarkResult$.MODULE$.apply$default$13();
                Option<MLMetric[]> x$31 = BenchmarkResult$.MODULE$.apply$default$15();
                Option<String> x$32 = BenchmarkResult$.MODULE$.apply$default$16();
                benchmarkResult = new BenchmarkResult(x$17, x$18, x$19, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, (Option<Failure>)x$20, x$31, x$32);
            }
        }
        finally {
            Option$.MODULE$.apply(this.testData()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.unpersist());
            Option$.MODULE$.apply(this.trainingData()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.unpersist());
        }
        return benchmarkResult;
    }

    public String prettyPrint() {
        String paramString = MLPipelineStageBenchmarkable$.MODULE$.com$databricks$spark$sql$perf$mllib$MLPipelineStageBenchmarkable$$pprint(this.params).mkString("\n");
        return new StringBuilder(1).append(this.test).append("\n").append(paramString).toString();
    }

    public MLPipelineStageBenchmarkable(MLParams params, BenchmarkAlgorithm test, SQLContext sqlContext) {
        this.params = params;
        this.test = test;
        Benchmarkable.$init$(this);
        this.testData = null;
        this.trainingData = null;
        this.testDataCount = None$.MODULE$;
        this.param = new MLBenchContext(params, sqlContext);
        this.name = test.name();
        this.executionMode = ExecutionMode$SparkPerfResults$.MODULE$;
    }
}

